@extends('layout.app')
@section('title', 'Pricing')


@section('content')
    <main class="pri-main">

        {{-- pricing section --}}
        @component('page.components.pricing-section')
        @endcomponent

        {{-- payment section --}}
        <section class="payment-section">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="payment-main">
                            <h2 class="section-title">Billing & Payment</h2>
                            <form class="m-0">
                                <div class="payment-area">
                                    <label class="form-label m-0">Payment Methods</label>
                                    <ul class="payment-method-list">
                                        <li class="payment-method-list-item">
                                            <button class="payment-method-btn" type="button">
                                                <img class="img-fluid" src="{{ asset(path: 'themes/images/credit-card-icon.svg') }}" alt="">
                                            </button>
                                        </li>
                                        <li class="payment-method-list-item">
                                            <button class="payment-method-btn" type="button">
                                                <img class="img-fluid" src="{{ asset(path: 'themes/images/check2-icon.svg') }}" alt="">
                                            </button>
                                        </li>
                                        <li class="payment-method-list-item">
                                            <button class="payment-method-btn" type="button">
                                                <img class="img-fluid" src="{{ asset(path: 'themes/images/apple-icon.svg') }}" alt="">
                                            </button>
                                        </li>
                                        <li class="payment-method-list-item">
                                            <button class="payment-method-btn" type="button">
                                                <img class="img-fluid" src="{{ asset(path: 'themes/images/google-icon.svg') }}" alt="">
                                            </button>
                                        </li>
                                        <li class="payment-method-list-item">
                                            <button class="payment-method-btn" type="button">
                                                <img class="img-fluid" src="{{ asset(path: 'themes/images/bitcoin-icon.svg') }}" alt="">
                                            </button>
                                        </li>
                                    </ul>
                                    <div class="selected-plan-area">
                                        <h6 class="selected-title m-0">Selected Plan:</h6>
                                        <h5 class="selected-plan m-0">$9.99/month</h5>
                                    </div>
                                    <div class="form-input-area">
                                        <label class="form-label">Have a coupon code?</label>
                                        <div class="d-flex justify-content-start align-items-center gap-3">
                                            <input class="payment-form-input" type="text" name="coupon" id="coupon" placeholder="Enter coupon code">
                                            <button class="coupon-btn" type="button">Apply</button>
                                        </div>
                                    </div>
                                    <div class="form-input-area">
                                        <label class="form-label">Full Name</label>
                                        <input class="payment-form-input" type="text" name="" id="" placeholder="Enter full name">
                                    </div>
                                    <div class="form-input-area">
                                        <label class="form-label">Billing Address</label>
                                        <input class="payment-form-input" type="text" name="" id="" placeholder="Enter billing address">
                                    </div>
                                    <div class="form-input-area">
                                        <label class="form-label">Card Number</label>
                                        <input class="payment-form-input" type="text" name="" id="" placeholder="XXXX XXXX XXXX XXXX">
                                    </div>
                                    <div class="row">
                                        <div class="col-12 col-lg-6">
                                            <div class="form-input-area">
                                                <label class="form-label">Expiry</label>
                                                <input class="payment-form-input" type="text" name="" id="" placeholder="MM/YY">
                                            </div>
                                        </div>
                                        <div class="col-12 col-lg-6">
                                            <div class="form-input-area">
                                                <label class="form-label">CVC</label>
                                                <input class="payment-form-input" type="text" name="" id="" placeholder="XXX">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-input-area checkbox">
                                        <input class="payment-checkbox d-none" type="checkbox" name="" id="agree-terms">
                                        <label for="agree-terms" class="pay-check-label">
                                            <span class="checkbox-square">
                                                <img class="img-fluid" src="{{ asset(path: 'themes/images/check-icon.svg') }}" alt="">
                                            </span>
                                            <span class="checkbox-text">Agree to terms and start subscription</span>
                                        </label>
                                    </div>
                                    <div class="payment-form-btm">
                                        <button class="pay-submit-btn secondary-btn2" type="submit">
                                            Purchase
                                        </button>
                                        <p class="pay-form-note mb-2">30-Day Money-Back Guarantee</p>
                                        <p class="pay-form-note m-0">Secure payment processing</p>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        {{-- pricing bottom section --}}
        <section class="pricing-bottom-section">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="bottom-section-main">
                            <div class="bottom-main-inner">
                                <img class="img-fluid" src="{{ asset(path: 'themes/images/shield-icon.svg') }}" alt="shield">
                                <h5 class="btm-sec-title">Secure Payments</h5>
                            </div>
                            <div class="bottom-main-inner">
                                <img class="img-fluid" src="{{ asset(path: 'themes/images/lock-icon.svg') }}" alt="lock">
                                <h5 class="btm-sec-title">SSL Protected</h5>
                            </div>
                            <div class="bottom-main-inner">
                                <img class="img-fluid" src="{{ asset(path: 'themes/images/user-icon.svg') }}" alt="user">
                                <h5 class="btm-sec-title">Trusted by Thousands</h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>
@endsection


@push('script')
@endpush